(in-package :MIP)                                
(use-package :OLI)        

(sd-defdialog 'mip-make-thread
 :dialog-title "THREAD"
 :variables
 '(
   (FACE
   	:selection  (*sd-cylinder-seltype*)
   	:title "FACE"
   	:prompt-text "Select face to define the thread"
        :after-input (progn
          (setf props  (sd-inq-geo-props FACE :dest-space :global))
          (setf radius (sd-cylinder-radius    props))
          (setf CYLDIA (* 2 radius))
          (setf thname (format nil "M~a" CYLDIA))
        )
   )     

   (CYLDIA  :value-type :display-only
            :title  "Diameter"
            :display-units :length
   )	  

   (CYLCORE  :value-type :display-only
            :title  "Core Dia"
            :display-units :length
   )	  

   ("-")

   (PITCH :value-type :number
     	  :title "PITCH"
          :proposals ("1.0" "1.25" "1.5" "2.0" "2.5" "3.0")
   	  :prompt-text "Enter pitch to define the thread"
          :after-input (progn
            (setf cored (- (* 2 radius) (* 2 PITCH)) ) 
            (setf CYLCORE cored)
          )
   )	  
  

  )
 :ok-action 
   '(progn
  	  (sd-define-thread face
		 :nominal-diameter (* 2 radius)
		 :pitch PITCH
		 :thread-type :outer
		 :core-diameter (- (* 2 radius) (* 2 PITCH))
		 :thread-unit :metric
		 :thread-color 0.94,0.75,0.75
		 :include-chamfer t
		 :thread-direction :cyl-axis
		 :thread-name thname)
    )
)             		       
