(in-package :MIP_DEMO)
(use-package :OLI)

;-----------------------

(sd-defdialog 'wp_on_face
                       
 :variables
 '(

   (AFACE   :value-type :face
            :title "Face"
            :prompt-text  "Select face"
            :incl-position  :3d
            :after-input (block blk1
              
              (let (projpkt
                    u v n1
                    )
              
              (setf projpkt (sd-proj-pnt-on-face (first aface) (second aface) :source-space :global :sf-space nil))
        
              ;if projection does not exist
        
              (if (not (sd-face-relax-pnt-p projpkt))
                (progn
                  (sd-display-message  (format nil "<Err> Point cannot be projected onto surface !!"))
                  (return-from blk nil)
                )
              )
            
              (setf u (sd-face-relax-pnt-u projpkt))
              (setf v (sd-face-relax-pnt-v projpkt))
            
              (setf n1 (getf (sd-inq-face-pnt (first aface) :u u  :v v 
                  :normal t :dest-space :GLOBAL ) :normal ))
              
              (sd-call-cmds (create_workplane :new  :pt_dir :origin (second aface) :normal n1))
            
              )
            
            )
  )

 )  
)
